<?php

namespace App\Http\Controllers\Front;

use App\Models\Category;
use App\Models\Setting;
use App\Models\Contact;
use App\Models\Blog;
use App\Models\Page;
use App\Models\Tag;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class IndexController extends Controller
{

    public function index(){   
      
     return view('front.home.index');
    }
  



    public function page(){
    	return view('front.pages.index');
    }

    public function subservices($slug){  

      $page=Page::where('slug',$slug)->where('status',1)->orderBy('weight','asc')->first();  
      return view('front.pages.index',compact('page'));

     }


     public function search(){
      $search=request()->query('search');
  if($search){
   $blogs= Blog::where('heading','LIKE','%'.$search.'%')->simplePaginate(5);
    
    }else{
     $blogs= Blog::simplePaginate(5);
     }
     return view('front.pages.blog',compact('search','blogs'));


}

public function contact(){

  return view('front.pages.contact');
}
      

     public function subchild_page($subchild_slug){  
    
      $page=Page::where([['status',1],['position','header'],['slug',$subchild_slug]])->first();
      return view('front.pages.subchild_page',compact('page'));

    }

     public function readabout($slug){  
      return view('front.pages.readmore',compact('slug'));
    }


    public function store(Request $request){
      

        Contact::create([
       "name" =>$request->name,
       "email" =>$request->email,
       "number"=>$request->number,
       "subject"=>$request->subject,
       "message"=>$request->message,
      ]);
      
        session()->flash('success','Message sucesfully sent');
        return redirect()->back();

    }


    public function categorydetail($id){
    
      $category_blogs=Blog::where('category_id',$id)->SimplePaginate(5);
      $categeory=Category::where('id',$id)->first();
    

      return view('front.pages.blog',compact('category_blogs','categeory'));
    }



           public function blog_detail($slug){
      
      $blog=Blog::where('status',1)->where('slug',$slug)->first();
           return view('front.pages.blog_detail',compact('blog'));    

       }


       public function tags($tag){

            $tag_blog=Tag::findorfail($tag);
             $tags=$tag_blog->blogs()->simplePaginate(5); 
             
           return view('front.pages.tag',compact('tags','tag_blog'));
    }



    


   public function support($subchild_slug){
     
    return view('front.pages.support',compact('subchild_slug'));
   }



    //
}

